﻿//////////////////////////////////////////////
// EffectType.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ----------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/String.h>
#include <NilkinsMemory/Containers/StringView.h>

/// Enum --------------------------------------

namespace nkAstraeus
{
	enum class EFFECT_TYPE
	{
		UNKNOWN = 0,
		ATMOSPHERE,
		FILM_GRAIN,
		FXAA,
		IMAGE_ENVIRONMENT,
		SSAO,
		TEXTURE_COPY,
		TONE_MAPPING
	} ;

	class DLL_ASTRAEUS_EXPORT EffectTypeUtils final
	{
		public :

			// Translation
			static nkMemory::StringView enumToString (EFFECT_TYPE value) ;
			static EFFECT_TYPE stringToEnum (nkMemory::StringView value) ;

		private :

			// Constructor, destructor
			EffectTypeUtils () noexcept = delete ;
			~EffectTypeUtils () = delete ;
	} ;
}